
(function(){
  function createIframe(src){
    var ifr = document.createElement('iframe');
    ifr.setAttribute('src', src);
    ifr.setAttribute('loading', 'lazy');
    ifr.setAttribute('frameborder', '0');
    ifr.setAttribute('allow', 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share');
    ifr.setAttribute('allowfullscreen', 'allowfullscreen');
    ifr.style.width = '100%';
    ifr.style.height = '100%';
    return ifr;
  }

  function onClick(e){
    var wrap = e.currentTarget;
    var src = wrap.getAttribute('data-iframe-src');
    if (!src) return;

    // Enable autoplay on click if possible
    if (src.indexOf('youtube.com') !== -1 || src.indexOf('youtu.be') !== -1){
      src += (src.indexOf('?') === -1 ? '?' : '&') + 'autoplay=1';
    }
    if (src.indexOf('vimeo.com') !== -1){
      src += (src.indexOf('?') === -1 ? '?' : '&') + 'autoplay=1';
    }

    wrap.innerHTML = '';
    wrap.appendChild(createIframe(src));
    wrap.classList.add('wphs-loaded');
  }

  function init(){
    var nodes = document.querySelectorAll('.wphs-video-placeholder');
    for (var i=0;i<nodes.length;i++){
      (function(wrap){
        wrap.addEventListener('click', function(){ onClick({currentTarget: wrap}); }, {once:true});
      })(nodes[i]);
    }
  }

  if (document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
})();
