<?php
namespace WPHS;

if (!defined('ABSPATH')) { exit; }

final class Plugin {
    private static $instance = null;

    /** @var array<string,mixed> */
    public $settings = [];

    public static function instance(): self {
        if (self::$instance === null) {
            self::$instance = new self();
            self::$instance->boot();
        }
        return self::$instance;
    }

    private function __construct() {}

    private function boot(): void {
        // i18n
        add_action('init', [$this, 'load_textdomain']);

        // Settings
        $this->settings = Settings::get();

        // Admin
        if (is_admin()) {
            require_once WPHS_PATH . 'includes/admin/class-wphs-admin.php';
            Admin::init();
        }

        // Features
        require_once WPHS_PATH . 'includes/features/class-wphs-emojis-embeds.php';
        require_once WPHS_PATH . 'includes/features/class-wphs-lazyload.php';
        require_once WPHS_PATH . 'includes/features/class-wphs-video-placeholders.php';
        require_once WPHS_PATH . 'includes/features/class-wphs-page-cache.php';

        Features\EmojisEmbeds::init();
        Features\LazyLoad::init();
        Features\VideoPlaceholders::init();
        Features\PageCache::init();

        // Licensing framework
        Licensing::init();
    }

    public function load_textdomain(): void {
        load_plugin_textdomain('wp-hyperspeed', false, dirname(plugin_basename(WPHS_PATH . 'wp-hyperspeed.php')) . '/languages');
    }
}
