<?php
namespace WPHS;

if (!defined('ABSPATH')) { exit; }

final class Settings {
    const OPTION_KEY = 'wphs_settings';

    /** Default settings */
    public static function defaults(): array {
        return [
            // Cache
            'cache_enabled' => true,
            'cache_ttl_hours' => 12,
            'cache_mobile' => true,

            // Media
            'lazyload_images' => true,
            'lazyload_iframes' => true,
            'lazyload_exclude_classes' => "custom-logo\nsite-logo",
            'lazyload_exclude_url_contains' => "logo\n/hero/\n/banner/",
            'video_placeholders' => true,

            // Tweaks
            'disable_emojis' => true,
            'disable_embeds' => true,
        ];
    }

    public static function get(): array {
        $saved = get_option(self::OPTION_KEY, []);
        if (!is_array($saved)) { $saved = []; }
        return array_merge(self::defaults(), $saved);
    }

    public static function update(array $new): void {
        $merged = array_merge(self::get(), $new);
        update_option(self::OPTION_KEY, $merged, false);
    }
}
