<?php
namespace WPHS\Features;

use WPHS\Settings;

if (!defined('ABSPATH')) { exit; }

final class EmojisEmbeds {
    public static function init(): void {
        add_action('init', [__CLASS__, 'maybe_disable'], 1);
    }

    public static function maybe_disable(): void {
        $s = Settings::get();

        if (!empty($s['disable_emojis'])) {
            remove_action('wp_head', 'print_emoji_detection_script', 7);
            remove_action('admin_print_scripts', 'print_emoji_detection_script');
            remove_action('wp_print_styles', 'print_emoji_styles');
            remove_action('admin_print_styles', 'print_emoji_styles');
            remove_filter('the_content_feed', 'wp_staticize_emoji');
            remove_filter('comment_text_rss', 'wp_staticize_emoji');
            remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
            add_filter('emoji_svg_url', '__return_false');
        }

        if (!empty($s['disable_embeds'])) {
            remove_action('wp_head', 'wp_oembed_add_discovery_links');
            remove_action('wp_head', 'wp_oembed_add_host_js');
        }
    }
}
