<?php
if (!defined('WP_UNINSTALL_PLUGIN')) { exit; }
delete_option('wphs_settings');
delete_option('wphs_instance_id');
delete_option('wphs_license_key');
delete_option('wphs_license_last_check');
delete_option('wphs_license_last_good');

// Remove cache dir if exists
$dir = WP_CONTENT_DIR . '/cache/wp-hyperspeed';
if (is_dir($dir)) {
    $it = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::CHILD_FIRST
    );
    foreach ($it as $file) {
        if ($file->isDir()) { @rmdir($file->getRealPath()); }
        else { @unlink($file->getRealPath()); }
    }
    @rmdir($dir);
}
